<div id="program" class="form-body p-3 mt-3 position-relative">
    <h2>
        <?php echo strtoupper('chosen structure program'); ?>

    </h2>
    <div class="row-2">
        <div class="form-row">
            <label for="class-id"><?php echo strtoupper('Structure program id'); ?></label>
            <select id="class-id" disabled>
                <option value=""><?php echo $data->class_structure_program->structure_program->id
                    ? $data->class_structure_program->structure_program->id
                    : '--'; ?></option>
            </select>
        </div>
        <div class="form-row">
            <label for="class-id"><?php echo strtoupper('Structured program occupation'); ?></label>
            <select id="class-id" disabled>
                <option value=""><?php echo $data->class_structure_program->structure_program->class_occupation->name
                    ? $data->class_structure_program->structure_program->class_occupation->name
                    : '--'; ?></option>
            </select>
        </div>
    </div>
    <div class="row-2">
        <div class="form-row">
            <label for="class-id"><?php echo strtoupper('Structured program description'); ?></label>
            <select id="class-id" disabled>
                <option value=""><?php echo $data->class_structure_program->structure_program->description
                    ? $data->class_structure_program->structure_program->description
                    : '--'; ?></option>
            </select>
        </div>
        <div class="button">
            <span>Action</span>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('structure-program-view-info')): ?>
                <button class="btn-create bg-primary w-100" @click="openStructureProgram()">
                    <span class="w-100"><?php echo strtoupper('View structured program'); ?></span>
                </button>
            <?php endif; ?>
            <button class="btn-create bg-primary w-100 mt-1" @click="dialogClassLog()">
                <span class="w-100"><?php echo strtoupper('view class log'); ?></span>
            </button>
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light font-sm">
                    <div class="row table-row-7">
                        <span class="font-sm"><?php echo strtoupper('Pro. Detail ID'); ?></span>
                    </div>
                    <div class="row table-row-6">
                        <span class="font-sm"><?php echo strtoupper('Lesson ID'); ?></span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm"><?php echo strtoupper('Lesson Name'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('Short Name'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('Lesson Occupation'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('Practice duration'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('Theory duration'); ?></span>
                    </div>
                    <div class="row table-row-7">
                        <span class="font-sm"><?php echo strtoupper('Attend Count'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('Progress'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('Progress %'); ?></span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    <?php
                        $sum_A = 0;
                    ?>
                    <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="column">
                            <div class="row table-row-7">
                                <span><?php echo $data->id ? $data->id : '--'; ?></span>
                            </div>
                            <div class="row table-row-6">
                                <span><?php echo $lesson->id ? $lesson->id : '--'; ?></span>
                            </div>
                            <div class="row table-row-20">
                                <span><?php echo $lesson->name ? $lesson->name : '--'; ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span><?php echo $lesson->short_name ? $lesson->short_name : '--'; ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span><?php echo $lesson->occupation->name ? $lesson->occupation->name : '--'; ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span><?php echo $lesson->practice_hour ? $lesson->practice_hour . ' ' . ($lesson->practice_duration_type ? $lesson->practice_duration_type : '') : '0'; ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span><?php echo $lesson->theory_hour ? $lesson->theory_hour . ' ' . ($lesson->theory_duration_type ? $lesson->theory_duration_type : '') : '0'; ?></span>
                            </div>
                            <div class="row table-row-7">
                                <span><?php echo e($lesson->attendance ? count($attendances->where('lesson_id', $lesson->id)) : '0'); ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    <?php echo e($lesson->practice_hour && $lesson->attendance ? count($attendances->where('lesson_id', $lesson->id)) . '/' . calcStudyDay([$lesson], 'practice') : '0'); ?>

                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span><?php echo e(number_format((count($attendances->where('lesson_id', $lesson->id)) / calcStudyDay([$lesson], 'practice')) * 100, 2)); ?>%</span>
                            </div>
                        </div>
                        <?php
                            $sum_A += count($attendances->where('lesson_id', $lesson->id));
                        ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="table-header bg-black text-light font-sm border-bl-br">
                    <div class="row table-row-53">
                        <span class="font-sm"><?php echo strtoupper('total'); ?></span>
                    </div>  
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo calcTime($lessons, 'practice') . '|' . calcStudyDay($lessons, 'practice') . 'day(s)'; ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo calcTime($lessons, 'theory') . '|' . calcStudyDay($lessons, 'theory') . 'day(s)'; ?></span>
                    </div>
                    <div class="row table-row-7">
                        <span class="font-sm"><?php echo e($sum_A > calcStudyDay($lessons, 'practice') ? calcStudyDay($lessons, 'practice') : $sum_A); ?> day(s)</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo e($sum_A > calcStudyDay($lessons, 'practice') ? calcStudyDay($lessons, 'practice') : $sum_A); ?>/<?php echo e(calcStudyDay($lessons, 'practice') . ' day(s)'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo e(number_format((($sum_A > calcStudyDay($lessons, 'practice') ? calcStudyDay($lessons, 'practice') : $sum_A ) / calcStudyDay($lessons, 'practice')) * 100, 2)); ?>%</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin::pages.class.view-info.modal.class-log', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin::pages.class.view-info.modal.view-structure-program', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    
    
    

    
    
    
    
</div>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/program.blade.php ENDPATH**/ ?>