<template x-if="addAnswerSheet">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3 h-auto" style="width: 210mm;">
            <div class="form-admin">
                <template x-if="status == false">
                    <div id="form" class="form-wrapper p-0">
                        <div class="form-header d-flex justify-content-between">
                            <h3 class="text-black m-0">
                                <?php echo e(strtoupper('Add new answer sheet')); ?>

                            </h3>
                            <span @click="dialogAddAnswerSheet()" class="btn-close cursor-pointer"></span>
                        </div>
                        <div class="form-body p-0">
                            <div class="row-2">
                                <div class="row p-3" style="width: 70%;">
                                    <div class="form-row">
                                        <label for=""><?php echo e(strtoupper('select subject')); ?>

                                            <span>*</span>
                                        </label>
                                        <select name="exam_subject_id" x-model="exam_subject_id">
                                            <option value="">Select...</option>
                                            <template x-if="exam_subject.length > 0">
                                                <template x-for="data in exam_subject">
                                                    <option :value="data.id" x-text="data.description"></option>
                                                </template>
                                            </template>
                                        </select>
                                        <span class="error" x-show="validate?.exam_subject_id"
                                            x-text="validate?.exam_subject_id"></span>
                                    </div>
                                    <div class="form-row">
                                        <label for=""><?php echo e(strtoupper('exam candidate')); ?>

                                            <span>*</span>
                                        </label>
                                        <select name="exam_candidate_id" x-model="exam_candidate_id">
                                            <option value="">Select...</option>
                                            <template x-if="exam_candidate.length > 0">
                                                <template x-for="item in exam_candidate">
                                                    <option :value="item.id" x-text="item.student.name_khmer"></option>
                                                </template>
                                            </template>
                                        </select>
                                        <span class="error" x-show="validate?.exam_candidate_id"
                                            x-text="validate?.exam_candidate_id"></span>
                                    </div>
                                    <div class="form-row">
                                        <label><?php echo e(strtoupper('acquired score (max = 100)(%)')); ?><span>*</span></label>
                                        <input type="number" name="acquired_score" x-model="acquired_score" min="0"
                                            max="100" step="0.5">
                                        <span class="error" x-show="validate?.acquired_score"
                                            x-text="validate?.acquired_score"></span>
                                    </div>
                                </div>
                                <div class="row p-3" style="width: 30%;">
                                    <div class="form-row">
                                        <label><?php echo e(strtoupper("Doc:")); ?></label>
                                        <div class="form-select-photo image" @click="selectImage()">
                                            <div>
                                                <template x-if="answer_sheet != null">
                                                    <div class="select-photo active">
                                                        <div class="icon">
                                                            <i data-feather="image"></i>
                                                        </div>
                                                        <div class="title">
                                                            <span><?php echo e(strtoupper('Upload doc Image')); ?></span>
                                                        </div>
                                                    </div>
                                                </template>
                                                <template x-if="answer_sheet == null">
                                                    <div class="select-photo">
                                                        <div class="icon">
                                                            <i data-feather="image"></i>
                                                        </div>
                                                        <div class="title">
                                                            <span><?php echo e(strtoupper('Upload doc Image')); ?></span>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>
                                            <input type="hidden">
                                            <template x-if="answer_sheet != null">
                                                <div class="image-view active">
                                                    <img :src="baseImageUrl + answer_sheet"
                                                        onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'"
                                                        alt="">
                                                </div>
                                            </template>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button @click="createExamAnswerSheet(<?php echo e(request('class_id')); ?>)"
                                class="bg-primary w-auto d-flex justify-content-end" style="border-radius: 4px;">
                                <span class="text-light">
                                    បញ្ចូល
                                </span>
                            </button>
                        </div>
                    </div>
                </template>
                <template x-if="status == true">
                    <form id="form" class="form-wrapper p-0">
                        <div class="form-header d-flex justify-content-between">
                            <h3 class="text-black m-0">
                                <?php echo e(strtoupper('Add new answer sheet')); ?>

                            </h3>
                            <span @click="editExamAnswerSheet()" class="btn-close cursor-pointer"></span>
                        </div>
                        <div class="form-body p-0">
                            <div class="row-2">
                                <div class="row p-3" style="width: 70%;">
                                    <div class="form-row">
                                        <label for=""><?php echo e(strtoupper('select subject')); ?>

                                            <span>*</span>
                                        </label>
                                        <label style="    width: 100%;
                                        border: 1px solid #d8dce5;
                                        padding: 10px;
                                        border-radius: 4px;
                                        text-align: left;" x-text="exam_as.exam_subject.description"></label>
                                    </div>
                                    <div class="form-row">
                                        <label for=""><?php echo e(strtoupper('exam candidate')); ?>

                                            <span>*</span>
                                        </label>
                                        <label style="    width: 100%;
                                        border: 1px solid #d8dce5;
                                        padding: 10px;
                                        border-radius: 4px;
                                        text-align: left;" x-text="exam_as.exam_candidate.student.name_khmer"></label>
                                    </div>
                                    <div class="form-row">
                                        <label><?php echo e(strtoupper('acquired score (max = 100)(%)')); ?><span>*</span></label>
                                        <input type="number" name="acquired_score" x-model="acquired_score" min=0
                                            max=100 step=0.5 :value="exam_as.acquired_score">
                                    </div>
                                </div>
                                <div class="row p-3" style="width: 30%;">
                                    <div class="form-row">
                                        <label><?php echo e(strtoupper("Doc:")); ?></label>
                                        <div class="form-select-photo image" @click="selectImage()">
                                            <div>
                                                <template x-if="answer_sheet != null">
                                                    <div class="select-photo active">
                                                        <div class="icon">
                                                            <i data-feather="image"></i>
                                                        </div>
                                                        <div class="title">
                                                            <span><?php echo e(strtoupper('Upload doc Image')); ?></span>
                                                        </div>
                                                    </div>
                                                </template>
                                                <template x-if="answer_sheet == null">
                                                    <div class="select-photo">
                                                        <div class="icon">
                                                            <i data-feather="image"></i>
                                                        </div>
                                                        <div class="title">
                                                            <span><?php echo e(strtoupper('Upload doc Image')); ?></span>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>
                                            <input type="hidden">
                                            <template x-if="answer_sheet == null && exam_as.answer_sheet != null">
                                                <div class="image-view active">
                                                    <img :src="baseImageUrl + exam_as.answer_sheet"
                                                        onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'"
                                                        alt="">
                                                </div>
                                            </template>
                                            <template
                                                x-if="(answer_sheet != null && exam_as.answer_sheet != null) || (answer_sheet == null && exam_as.answer_sheet == null) || (answer_sheet != null && exam_as.answer_sheet == null)">
                                                <div class="image-view active">
                                                    <img :src="baseImageUrl + answer_sheet"
                                                        onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'"
                                                        alt="">
                                                </div>
                                            </template>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button @click="createExamAnswerSheet(<?php echo e(request('class_id')); ?>, exam_as.id)"
                                class="bg-primary w-auto d-flex justify-content-end" style="border-radius: 4px;">
                                <span class="text-light">
                                    បញ្ចូល
                                </span>
                            </button>
                        </div>
                    </form>
                </template>
            </div>
        </div>
</template><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/examControl/examAnswerSheet/create.blade.php ENDPATH**/ ?>