<?php $__env->startSection('layout'); ?>
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="<?php echo route('admin-student-assign-class', request('id')); ?>" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="<?php echo route('admin-student-list', 1); ?>"></i>
                    Assign Student to Class
                </h3>
            </div>
            <?php echo e(csrf_field()); ?>

            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Selected student name</label>
                        <input type="text" value="<?php echo e($data->name_khmer); ?>" readonly>
                    </div>
                    <div class="form-row">
                        <label>Selected student ID</label>
                        <input type="text" value="<?php echo e($data->sid); ?>" readonly>
                    </div>
                </div>
                <?php if(count($data->classes) > 0): ?>
                    <div class="table-wrapper">
                        <span>STUDY HISTORY RECORD</span>
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-10">
                                <span><?php echo strtoupper('Class ID'); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span><?php echo strtoupper('Occupation'); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span><?php echo strtoupper('Trainer'); ?></span>
                            </div>
                            <div class="row table-row-25">
                                <span><?php echo strtoupper('Shift'); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span><?php echo strtoupper('Level'); ?></span>
                            </div>
                            <div class="row table-row-20">
                                <span><?php echo strtoupper('Proc.Status'); ?></span>
                            </div>
                        </div>
                        <div class="table-body">
                            <?php $__currentLoopData = $data->classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="column">
                                    <div class="row table-row-10">
                                        <span><?php echo $item->id; ?></span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            <?php echo $item->class_structure_program
                                                ? $item->class_structure_program->structure_program->class_occupation->name
                                                : '--'; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            <?php echo $item->staff->full_name; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <span>
                                            <?php echo $item->shift->name; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            <?php echo $item->class_level->name; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-20">
                                        <span>
                                            <?php echo $item->class_level->name; ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="form-row">
                        <label for="classes">Classes<span>*</span></label>
                        <?php if(count($classes) > 0): ?>
                            <select id="classes" name="class_id">
                                <option value="">Please select class to assign</option>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo $class->id; ?>">
                                        [Class ID: <?php echo $class->id; ?>]
                                        [<?php echo $class->shift->name; ?>]
                                        [<?php echo $class->class_status->name; ?>]
                                        [<?php echo $class->class_level->name; ?>]
                                        [<?php echo $class->class_type->name; ?>]
                                        [<?php echo 'GEN ' . $class->generation; ?>]
                                        [<?php echo 'GP ' . $class->group; ?>]
                                        [<?php echo 'code: ' . $class->class_code; ?>]
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo $message; ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php else: ?>
                            <label for=""><span>No Classes Available</span></label>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary" <?php echo e(count($classes) > 0 ? '' : 'disabled'); ?>>
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="<?php echo route('admin-student-list', 1); ?>">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    <?php echo $__env->make('admin::file-manager.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $("#date").datepicker({
                changeYear: true,
                dateFormat: "yy-mm-dd",
            });
        });
    </script>
    <script lang="ts">
        $(document).ready(function() {
            $validator("#form", {
                class_id: {
                    required: true,
                },
            });
        });

        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/student/assign-class.blade.php ENDPATH**/ ?>