<template x-data="{}" x-if="$store?.page?.active">
    <div class="dialog" x-bind:style="{ zIndex: $store.libs.getLastIndex() + 1 }">
        <div class="dialog-container" x-ref="popupRef" x-bind:onload="$store.libs.playAnimateOnLoad($refs.popupRef)">
            <template x-if="$store.page.active == 'all_files'">
                <?php echo $__env->make('admin::file-manager.all_files', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </template>
            <template x-if="$store.page.active == 'trash_bin'">
                <?php echo $__env->make('admin::file-manager.trash_bin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </template>
            <template x-if="$store.page.active == 'settings'">
                <?php echo $__env->make('admin::file-manager.settings', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </template>
        </div>
    </div>
</template>
<script type="module">
    moment.locale('<?php echo e(App::currentLocale()); ?>');
    Alpine.store('page', {
        active: false,
        options: {
            multiple: false,
            afterClose: () => {}
        }
    });

    window.fileManager = (options) => {
        Alpine.store('page', {
            active: 'all_files',
            options: options
        });
    };
</script>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/file-manager/popup.blade.php ENDPATH**/ ?>