<template x-if="dialogOpen">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3">
            <div class="d-flex flex-row-reverse justify-content-between">
                <span @click="dialogOpen=false" class="cursor-pointer btn-close">
                </span>
                <h2>
                    <?php echo strtoupper('Class log information'); ?>

                </h2>
            </div>
            <div class="row">
                <div class="form-row flex-row border-1 align-items-center p-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attendance-create')): ?>
                    <a href="<?php echo route('admin-attendance-create', $data->id); ?>">
                        <button class="btn-create bg-primary mr-2">
                            <span>Insert Program Att</span>
                        </button>
                    </a>
                    <?php endif; ?>
                    
                </div>
            </div>
            <div class="row" style="height: 85%">
                <span class="font-weight-bold text-black"><?php echo strtoupper('class log table'); ?></span>
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-5">
                                <span class="font-sm"><?php echo strtoupper('N'); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm"><?php echo strtoupper('Log date'); ?></span>
                            </div>
                            <div class="row table-row-65">
                                <span class="font-sm"><?php echo strtoupper('Lesson Name'); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm"><?php echo strtoupper('Action'); ?></span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="column">
                                <div class="row table-row-5">
                                    <span>
                                        <?php echo $index+1; ?>

                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        <?php echo isset($attendance->log_date) && $attendance->log_date ?
                                        $attendance->log_date : '--'; ?>

                                    </span>
                                </div>
                                <div class="row table-row-65">
                                    <span class="font-sm">
                                        <?php echo isset($attendance->lesson_id) && $attendance->lesson_id ?
                                        $attendance->lessons->short_name.'-'.$attendance->lessons->name : '--'; ?>

                                    </span>
                                </div>
                                <div class="row table-row-15 h-100 d-flex justify-content-center align-items-center">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attendance-destroy')): ?>
                                    <span class="font-sm h-50">
                                        <button class="btn-create bg-danger h-100" onclick="$onConfirmMessage(
                                            '<?php echo route('admin-attendance-delete', ['id' => $attendance->id, 'status' => 1]); ?>',
                                            'Are you sure to Delete Attendance on <?php echo e($attendance->log_date); ?>',
                                            {
                                                confirm: '<?php echo app('translator')->get('dialog.button.ok'); ?>',
                                                cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                            },
                                            );">
                                            <span>DELETE</span>
                                            </a>
                                        </button>
                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/modal/class-log.blade.php ENDPATH**/ ?>