<?php $__env->startSection('auth'); ?>
    <form class="form" id="login-form" action="<?php echo route('admin-login-post'); ?>" method="post">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="returnUrl" value=<?php echo e(request()->returnUrl); ?>>
        <h2 class="title"><?php echo app('translator')->get('auth.sign-in.title'); ?></h2>
        <div class="form-wrapper">
            <div class="form-row">
                <label for="username">
                    <i data-feather="user"></i>
                    <?php echo app('translator')->get('auth.sign-in.form.username.label'); ?>
                </label>
                <input name="email" placeholder="<?php echo app('translator')->get('auth.sign-in.form.username.placeholder'); ?>" type="text" error-message="<?php echo app('translator')->get('auth.sign-in.form.username.error'); ?>"
                    autocomplete="off">
            </div>
            <div class="form-row">
                <label for="password">
                    <i data-feather="key"></i>
                    <?php echo app('translator')->get('auth.sign-in.form.password.label'); ?>
                </label>
                <div class="group-input" x-data={show:false}>
                    <input name="password" x-bind:type="!show ? 'password' : 'text'" placeholder="<?php echo app('translator')->get('auth.sign-in.form.password.placeholder'); ?>"
                        error-message="<?php echo app('translator')->get('auth.sign-in.form.password.error'); ?>" autocomplete="off">
                    <div class="group-item" @click="show = !show">
                        <span x-show="!show">
                            <i data-feather="eye"></i>
                        </span>
                        <span x-show="show">
                            <i data-feather="eye-off"></i>
                        </span>
                    </div>
                </div>
            </div>
            <div class="option">
                <div class="remember-me">
                    <input name="remember" id="remember" type="checkbox" value="true">
                    <label for="remember"><?php echo app('translator')->get('auth.sign-in.form.remember'); ?></label>
                </div>
                
            </div>
            <button color="primary" class="btn-submit-form" type="submit">
                <span><?php echo app('translator')->get('auth.sign-in.form.button'); ?></span>
            </button>
        </div>
        <?php if(Session::has('status')): ?>
            <p class="q-label-error">
                <?php echo app('translator')->get('auth.sign-in.form.error_login'); ?>
            </p>
        <?php endif; ?>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            let validate = {
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                    minLength: 6,
                    maxLength: 20
                }
            };
            $validator("#login-form", validate, {
                inputClass: "error-input",
                messageClass: "error",
                showMessage: false
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin::auth.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/auth/sign-in.blade.php ENDPATH**/ ?>