<div class="navbar bg-black shadow-sm">
    <div class="container">
        <div class="navbar-top">
            <div class="flex flex-col items-center">
                <div class="top-left-header">
                    <h1 class="text-gray-300 text-[17px]">Customer Service:</h1>
                    <h1 class="text-gray-300 text-[17px]"><?php echo e(isset($contact?->phone) ? $contact?->phone : ''); ?></h1>
                </div>
            </div>
            <div class="logo">
                <a href="<?php echo e(route('website-home')); ?>">
                    <img src="<?php echo e(asset('website/images/logo/LICE_serge_comtesse_cambodia_black.png')); ?>" alt="" class="h-28">
                </a>
            </div>
            <div class="top-right-header">
                <div class="flex flex-col space-y-3">
                    <div class="top-right-header-search">
                        <form action="<?php echo e(route('website-course-search')); ?>" method="get">
                            <div
                                class="flex flex-row items-center justify-between -space-x-5 search border-b border-b-red-100">
                                <input type="text" name="search" class="text-gray-300" placeholder="Search here..."
                                    value="<?php echo e(request()->input('search')); ?>">
                                <button type="submit"><i class="fas fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="top-right-header-icons">
                        <div class="flex flex-row text-gray-300 space-x-3 items-center">
                            <span>Follow Us: </span>
                            <a href="<?php echo e(isset($contact?->facebook) ? $contact?->facebook : ''); ?>" target="__blank">
                                <i data-feather="facebook" class="w-5 h-5 !text-gray-200"></i>
                            </a>
                            <a href="<?php echo e(isset($contact?->instagram) ? $contact?->instagram : ''); ?>" target="__blank">
                                <i data-feather="instagram" class="w-5 h-5 !text-gray-200"></i>
                            </a>
                            <a href="<?php echo e(isset($contact?->telegram) ? $contact?->telegram : ''); ?>" target="__blank">
                                <i data-feather="send" class="w-5 h-5 !text-gray-200"></i>
                            </a>
                            <a href="<?php echo e(isset($contact?->youtube) ? $contact?->youtube : ''); ?>" target="__blank">
                                <i data-feather="youtube" class="w-5 h-5 !text-gray-200"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="navbar bg-black shadow-sm isFixed">
    <div class="container">
        <div class="navbar-menu menu flex items-center justify-between pb-2 pt-2">
            <div class="menu-content grid gap-6 grid-flow-col uppercase">
                <div class="menu-bar cursor-pointer" onclick="toggleMenuResponsive()">
                    <i class="fas fa-bars"></i>
                </div>
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['item', 'active' => !!Request::is('/')]) ?>" href="<?php echo e(route('website-home')); ?>">
                    Home
                </a>
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['item', 'active' => !!Request::is('course')]) ?>" href="<?php echo e(route('website-course-index')); ?>">
                    Course
                </a>
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['item', 'active' => !!Request::is('partner')]) ?>" href="<?php echo e(route('website-partner-index')); ?>">
                    Salon Partner
                </a>
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['item', 'active' => !!Request::is('gallery')]) ?>" href="<?php echo e(route('website-gallery-index')); ?>">
                    Gallery
                </a>
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['item', 'active' => !!Request::is('training')]) ?>" href="<?php echo e(route('website-training-index')); ?>">
                    Training Video
                </a>
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['item', 'active' => !!Request::is('page/about-us')]) ?>" href="<?php echo e(route('website-page-about-us')); ?>">
                    About
                </a>
            </div>
            <div class="logo-responsive">
                <a href="<?php echo e(route('website-home')); ?>">
                    <img src="<?php echo e(asset('website/images/logo/abhc.png')); ?>" alt="">
                </a>
            </div>
            <div class="account">
                <?php if(auth('web')->check() && auth('web')->user()->role == 'student' && isset($user)): ?>
                    <div class="flex items-center cursor-pointer">
                        <span class="mr-3 your-account">YOUR ACCOUNT</span>
                        <i class="fas fa-user"></i>
                    </div>

                    <div class="account-dropdown-content">
                        <div class="account-dropdown-content-list grid gap-4 w-full">
                            <div class="flex items-center">
                                <i class="fas fa-user"></i>
                                <span class="pl-2"><?php echo e($user?->name_latin); ?></span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-envelope"></i>
                                <span class="pl-2"><?php echo e($user?->email); ?></span>
                            </div>
                            <div class="flex items-center">
                                <i class="fas fa-phone"></i>
                                <span class="pl-2"><?php echo e($user?->phone); ?></span>
                            </div>
                            <div class="btnSignOut cursor-pointer flex items-cente"
                                data-url="<?php echo e(route('website-auth-sign-out')); ?>">
                                <i class="fas fa-sign-out-alt"></i>
                                <span class="pl-2">Sign Out</span>
                            </div>
                            <div class="flex">
                                <i class="fas fa-note-sticky text-sm"></i>
                                <?php if(auth('web')->user()->approval_status == 'pending'): ?>
                                    <span class="font-medium pl-2">
                                        Please Wait Until Admin Contact You!
                                    </span>
                                <?php else: ?>
                                    <span class="font-medium pl-2" style="text-transform: capitalize">
                                        <?php echo e(auth('web')->user()->approval_status); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="flex items-center cursor-pointer">
                        <a href="<?php echo e(route('website-auth-sign-in', ['returnUrl' => request()->url()])); ?>">
                            <span class="mr-2 your-account">YOUR ACCOUNT</span>
                            <i class="fas fa-user"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="phone-number flex flex-row justify-center mb-2">
            <span>
                <i class="fa-solid fa-phone text-yellow-600"></i>
            </span>
            <span class="text-gray-300 mx-3">Customer Service:</span>
            <span class="text-gray-300"><?php echo e($contact?->phone); ?></span>
        </div>
    </div>
</div>

<!-- menu responisve -->
<?php echo $__env->make('website::components.menu-responsive', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    /* script menu responsive */

    function toggleMenuResponsive() {
        $('.menu-responsive').toggleClass('menu-active');
        $('.menu-responsive-cover').toggleClass('menu-active');

        if ($('.menu-responsive-cover').hasClass('menu-active')) {
            $('body').css({
                'overflow': 'auto'
            });
        } else {
            $('body').css({
                'overflow': 'hidden'
            });
        }
    }
</script>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/shared/navbar.blade.php ENDPATH**/ ?>