<!-- Mobile nav -->
<section>
    <div class="menu-responsive menu-active">
        <div class="menu-header">
            <div class="right-logo">
                <a href="<?php echo e(route('website-home')); ?>" class="grid grid-flow-row items-center gap-2">
                    <img src="<?php echo e(asset('website/images/logo/abhc.png')); ?>" alt="logo">
                </a>
            </div>
            <div onclick="toggleMenuResponsive()">
                <span class="close-menu cursor-pointer">
                    <i class="fas fa-times"></i>
                </span>
            </div>
        </div>
        <div class="search-content">
            <form action="#" method="GET">
                <input type="text" name="search" required value="" placeholder="Search....">
                <button type="submit" class="btn"><i data-feather="search"></i></button>
            </form>
        </div>
        <div class="menu-content">
            <div class="grid grid-flow-row gap-2 pb-4">
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('/')]) ?>">
                    <a href="<?php echo e(route('website-home')); ?>">
                        Home
                    </a>
                </div>
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('course')]) ?>">
                    <a href="<?php echo e(route('website-course-index')); ?>">
                        Course
                    </a>
                </div>
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('partner')]) ?>">
                    <a href="<?php echo e(route('website-partner-index')); ?>">
                        Salon Partner
                    </a>
                </div>
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('gallery')]) ?>">
                    <a href="<?php echo e(route('website-gallery-index')); ?>">
                        Gallery
                    </a>
                </div>
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('training')]) ?>">
                    <a href="<?php echo e(route('website-training-index')); ?>">
                        Training Video
                    </a>
                </div>
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('page/about-us')]) ?>">
                    <a href="<?php echo e(route('website-page-about-us')); ?>">
                        About
                    </a>
                </div>
                <?php if(auth('web')->check() && auth('web')->user()->role == 'student' && isset($user)): ?>
                    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item relative']) ?>" x-data="{ isDropDownOpen: true }">
                        <div class="flex items-center justify-between">
                            Your Account
                            <div @click="isDropDownOpen = !isDropDownOpen"
                                :aria-expanded="isDropDownOpen ? 'true' : 'false'">
                                <i class="h-5 w-5" x-show="!isDropDownOpen" data-feather="chevron-right"></i>
                                <i class="h-5 w-5" x-show="isDropDownOpen" data-feather="chevron-down"></i>
                            </div>
                        </div>
                        <div class="dropdown-menu mt-3" x-show="isDropDownOpen" style="display:none"
                            x-transition:enter.duration.300ms>
                            <div class="grid gap-4 shadow-border pl-10 mt-1">
                                <div class="text-sm flex items-center">
                                    <i class="fas fa-user text-sm"></i>
                                    <span class="font-medium pl-2"><?php echo e($user?->username); ?></span>
                                </div>
                                <div class="text-sm flex items-center">
                                    <i class="fas fa-envelope text-sm"></i>
                                    <span class="font-medium pl-2"><?php echo e($user?->email); ?></span>
                                </div>
                                <div class="text-sm flex items-center">
                                    <i class="fas fa-phone text-sm"></i>
                                    <span class="font-medium pl-2"><?php echo e($user?->phone); ?></span>
                                </div>
                                <div class="btnSignOut text-sm cursor-pointer flex items-center"
                                    data-url="<?php echo e(route('website-auth-sign-out')); ?>">
                                    <i class="fas fa-sign-out-alt text-sm"></i>
                                    <span class="font-medium pl-2">Sign Out</span>
                                </div>
                                <div class="flex">
                                    <i class="fas fa-note-sticky text-sm"></i>
                                    <?php if(auth('web')->user()->approval_status == 'pending'): ?>
                                        <span class="font-medium pl-2">
                                            Please Wait Until Admin Contact You!
                                        </span>
                                    <?php else: ?>
                                        <span class="font-medium pl-2" style="text-transform: capitalize">
                                            <?php echo e(auth('web')->user()->approval_status); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['menu-item', 'active' => !!Request::is('signup')]) ?>">
                        <a href="<?php echo e(route('website-auth-sign-in', ['returnUrl' => request()->url()])); ?>">
                            Your Account
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="menu-responsive-cover menu-active" onclick="toggleMenuResponsive()"></div>
</section>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/components/menu-responsive.blade.php ENDPATH**/ ?>