<div class="table">
    <?php if($data->count() > 0): ?>
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>No</span>
            </div>
            <div class="row table-row-10">
                <span>Profile</span>
            </div>
            <div class="row table-row-20 text-left">
                <span>Name</span>
            </div>
            <div class="row table-row-15">
                <span>Email</span>
            </div>
            <div class="row table-row-15">
                <span>Phone</span>
            </div>
            <div class="row table-row-15">
                <span>Staff Type</span>
            </div>
            <div class="row table-row-15">
                <span>Staff Position</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="column">
                <div class="row table-row-5">
                    <span><?php echo $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1); ?></span>
                </div>
                <div class="row table-row-10">
                    <div class="thumbnail" data-fancybox data-src="<?php echo e(asset('file_manager' . $item->profile)); ?>">
                        <img src="<?php echo $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png'); ?>"
                            onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                    </div>
                </div>
                <div class="row table-row-20 text left bold">
                    <span><?php echo $item->full_name ? $item->full_name : '--'; ?></span>
                </div>
                <div class="row table-row-15 text">
                    <span><?php echo $item->email ? $item->email : '--'; ?></span>
                </div>
                <div class="row table-row-15 text">
                    <span><?php echo $item->phone ? $item->phone : '--'; ?></span>
                </div>
                <div class="row table-row-15">
                    <span>
                        <?php echo e($item->staff_type->name ?? '--'); ?>

                    </span>
                </div>
                <div class="row table-row-15">
                    <span>
                        <?php echo e($item->staff_position->name ?? '--'); ?>

                    </span>
                </div>
                <div class="row table-row-5">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['staff-update', 'staff-delete'])): ?>
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('staff-update')): ?>
                            <li>
                                <a class="dropdown-item" s-click-link="<?php echo route('admin-staff-create', $item->id); ?>">
                                    <i data-feather="edit"></i>
                                    <span><?php echo app('translator')->get('table.option.edit'); ?></span>
                                </a>
                            </li>
                            <?php if($item->status == 2): ?>
                            <li>
                                <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-staff-status', ['id' => $item->id, 'status' => 1]); ?>',
                                                                '<?php echo app('translator')->get('dialog.msg.enable', ['name' => $item->name]); ?>',
                                                                {
                                                                    confirm: '<?php echo app('translator')->get('dialog.button.enable'); ?>',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                },
                                                            );">
                                    <i data-feather="rotate-ccw"></i>
                                    <span><?php echo app('translator')->get('table.option.enable'); ?></span>
                                </a>
                            </li>
                            <?php else: ?>
                            <li>
                                <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-staff-status', ['id' => $item->id, 'status' => 2]); ?>',
                                                                '<?php echo app('translator')->get('dialog.msg.disable', ['name' => $item->name]); ?>',
                                                                {
                                                                    confirm: '<?php echo app('translator')->get('dialog.button.disable'); ?>',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                }
                                                            );">
                                    <i data-feather="x-circle"></i>
                                    <span><?php echo app('translator')->get('table.option.disable'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <div class="table-footer">
            <?php echo $__env->make('admin::components.pagination', ['paginate' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <?php else: ?>
    <?php $__env->startComponent('admin::components.empty', [
    'name' => 'Staff is empty',
    'msg' => 'You can create a new staff by clicking the button below.',
    'permission' => 'staff-create',
    'url' => route('admin-staff-create'),
    'button' => 'Create Staff',
    ]); ?>
    <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
</div><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/staff/table.blade.php ENDPATH**/ ?>