<div id="student-list" class="form-body p-3 mt-3">
    <h2>
        <?php echo strtoupper('Student list'); ?>

    </h2>
    <form action="<?php echo e(route('admin-printing-student', ['about'=> true, 'id'=>request('id')])); ?>" method="GET">
        <div class="row">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-print')): ?>
            <div class="form-row flex-row">
                <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-3"
                    style="border-radius: 5px" @click="toggleAllCheckboxes()">
                    <span class="text-light"><?php echo strtoupper('Checked all'); ?></span>
                </div>
                <button class="btn-create bg-primary mr-2" type="submit">
                    <i data-feather="printer"></i>
                    <span><?php echo strtoupper('print'); ?></span>
                </button>
                <div class="checkItem mr-2 d-flex justify-content-center align-items-center">
                    <label for="image">Show Image</label>
                    <input type="checkbox" name="show_image" value="true" id="image" checked />
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header bg-black text-light">
                        <div class="row table-row-7">
                            <span class="font-sm"><?php echo strtoupper('select'); ?></span>
                        </div>
                        <div class="row table-row-6">
                            <span class="font-sm"><?php echo strtoupper('STU. ID'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm"><?php echo strtoupper('Student name KH'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm"><?php echo strtoupper('student name'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('Tel.'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('Gender'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('Date of Birth'); ?></span>
                        </div>
                        <div class="row table-row-12">
                            <span class="font-sm"><?php echo strtoupper('other'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('joined on'); ?></span>
                        </div>
                        <div class="row table-row-5">
                            <span class="font-sm"><?php echo strtoupper('action'); ?></span>
                        </div>
                    </div>
                    <div class="table-body overflow-visible">
                        <?php $__currentLoopData = $data->students->sortBy('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="column">
                            <div class="row table-row-7">
                                <span>
                                    <input class="item-select-input" type="checkbox" name="student_id[]"
                                        value="<?php echo $student->id; ?>" x-model="selectStudents" />
                                </span>
                            </div>
                            <div class=" row table-row-6">
                                <span>
                                    <?php echo $student->id ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-15">
                                <span>
                                    <?php echo $student->name_khmer ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-15">
                                <span>
                                    <?php echo $student->name_latin ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    <?php echo $student->phone ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    <?php echo $student->gender ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    <?php echo $student->dob ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-12">
                                <span>
                                    <?php echo $student->note ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    <?php echo $student->pivot->created_at ?? '--'; ?>

                                </span>
                            </div>
                            <div class="row table-row-5">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['student-view-info', 'class-remove-student'])): ?>
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-view-info')): ?>
                                        <li>
                                            <a class="dropdown-item"
                                                s-click-link=" <?php echo route('admin-student-view', $student->id); ?>">
                                                <i data-feather="monitor"></i>
                                                <span>View Info</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('class-remove-student')): ?>
                                        <li>
                                            <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                    '<?php echo route('admin-class-remove-student', ['student_id' => $student->id, 'class_id' => request('id')]); ?>',
                                                    'Are you sure to remove <?php echo e($student->name_khmer); ?> from class <?php echo e(request('id')); ?>',
                                                    {
                                                        confirm: '<?php echo app('translator')->get('dialog.button.ok'); ?>',
                                                        cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                    }
                                                );">
                                                <i data-feather="x-circle"></i>
                                                <span>Remove Student</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/student-list.blade.php ENDPATH**/ ?>