@extends('admin::shared.layout')
@section('layout')
<div class="form-admin" x-data="xCreateAttendance">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-attendance-save') !!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left" s-click-link="{{ url()->previous() }}"></i>
                {!! "Insert Attendance" !!}
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row">
                <div class="form-row">
                    <label for="class">លេខកូដថ្នាក់</label>
                    <select name="class_id" id="class">
                        <option value="{!! request('class_id') !!}">
                            {!! request('class_id') !!}
                        </option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>
                        សូមជ្រើសរើសមុខវិជ្ជា
                    </label>
                    <select name="lesson_id">
                        <option value="">សូមជ្រើសរើស...</option>
                        @foreach($lessons as $lesson)
                        @if(in_array($lesson->id, $lessons_id))
                        <option value="{{$lesson->id}}">
                            {{$lesson->short_name.'-'.$lesson->name}}
                        </option>
                        @endif
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>
                        សូមជ្រើសរើសប្រអប់ខាងក្រោម
                    </label>
                    <div class="table">
                        <span class="d-flex justify-content-center align-items-center">
                            បញ្ជីឈ្មោះសិស្ស
                        </span>
                        <span class="btn btn-create cursor-pointer bg-primary text-light"
                            @click="toggleAllCheckboxes()">Check All</span>
                        <div class=" table-wrapper">
                            <div class="table-header bg-black text-light">
                                <div class="row table-row-20">
                                    <span>គូសវត្តមាន</span>
                                </div>
                                <div class="row table-row-20">
                                    <span>លេខរៀង</span>
                                </div>
                                <div class="row table-row-35">
                                    <span>ឈ្មោះសិស្ស</span>
                                </div>
                                <div class="row table-row-25">
                                    <span>រូបភាព</span>
                                </div>
                            </div>
                            <div class="table-body overflow-auto">
                                @foreach($students as $index => $student)
                                <div class="column h-col">
                                    <div class="row table-row-20">
                                        <span class="d-flex justify-content-center align-items-center">
                                            <input type="checkbox" name="student_id[]" class="item-select-input"
                                                value=" {{ $student->id }}" x-model="selectStudents">
                                        </span>
                                    </div>
                                    <div class="row table-row-20">
                                        <span>
                                            {{$index+1}}
                                        </span>
                                    </div>
                                    <div class="row table-row-35">
                                        <span>
                                            {{$student->name_khmer}}
                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <div class="thumbnail photo" data-fancybox
                                            data-src="{{ asset('file_manager' . $student->profile)  }}">
                                            <img src="{!! $student->profile != null ? asset('file_manager' . $student->profile) : asset('images/logo/default.png') !!}"
                                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <button type="submit" class="btn-create bg-primary w-100" s-click-link="">
                    <span class="w-100">
                        បញ្ចូលទិន្នន័យ
                    </span>
                </button>
                <button class="btn-create bg-primary w-100 mt-4" s-click-link="{!! url()->previous() !!}">
                    <span class="w-100">
                        បង្ហាញទិន្នន័យដែលបានបញ្ចូលថ្ងៃនេះ
                    </span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop

@section('script')
<script lang="ts">
    $(document).ready(function() {
        $validator("#form", {
            student_id: {
                required: true,
            },
            lesson_id: {
                required: true,
            },
        });
        // document.addEventListener('contextmenu', function(e) {
        //     e.preventDefault();
        // });

    })
</script>

<script>
    Alpine.data('xCreateAttendance', () => ({
        selectAll : false, 
        selectStudents: [],
        toggleAllCheckboxes() {
            this.selectAll = !this.selectAll
            this.selectStudents = [];

            checkboxes = document.querySelectorAll('.item-select-input');
            [...checkboxes].map((el) => {
                el.checked = this.selectAll;
                (this.selectAll) ? this.selectStudents.push(el.value) : this.selectStudents = [];
            })
        },
        init(){
        },
    }));
</script>
@stop