@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-class-save-assign-structured', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-structure-program-list', 1) !!}"></i>
                    Assign Class to Structured Program
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label for="classes">Please assign this class with id of {!! $data->id !!} to<span>*</span></label>
                        <select id="classes" name="structure_program_id">
                            <option value="">Please select structured program to assign</option>
                            @foreach($structured_programs as $structured_program)
                                @if(!$structured_program->class_structure_program)
                                    <option value="{!! $structured_program->id !!}">
                                        [Struct. ID: {!! $structured_program->id !!}]
                                        [Class Occu.: {!! $structured_program->class_occupation->name !!}]
                                        [Lesson:
                                    @foreach($lessons as $lesson)
                                            @if(in_array($lesson->id, $structured_program->lesson_id))
                                                {!! $lesson->short_name !!},
                                            @endif
                                    @endforeach
                                        ]
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-structure-program-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script>
        $(document).ready(function() {
            $("#date").datepicker({
                changeYear: true,
                dateFormat: "yy-mm-dd",
            });
        });
    </script>
@stop
