@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper" x-data="xViewInfo">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Display Class Info'])
        <div class="header-tab">
            @include('admin::pages.class.view-info.header')
        </div>
    </div>
    <div class="form-admin p-5 mt-2 mb-2">
        <div class="form-wrapper p-0">
            @if(isset($data->class_structure_program->structure_program))
            @include('admin::pages.class.view-info.class-info')
            @include('admin::pages.class.view-info.program')
            @include('admin::pages.class.view-info.student-list')
            @include('admin::pages.class.view-info.overall')
            @include('admin::pages.class.view-info.attendance')
            @include('admin::pages.class.view-info.student-score')
            @include('admin::pages.class.view-info.study-intern')
            @include('admin::pages.class.view-info.group')
            @include('admin::pages.class.view-info.cer')
            @include('admin::pages.class.view-info.study-note')
            @else
            @include('admin::pages.class.view-info.class-info')
            @can('class-assign')
            @include('admin::pages.class.view-info.non-assign')
            @endcan
            @endif
        </div>
    </div>
    <template x-if="loading">
        <div class="loading">
            <div class="sub-loading">
                {{-- <div class="w-100 p-2 d-flex justify-content-end align-items-center">
                    <span @click="loading=false" class="cursor-pointer btn-close m-0">
                    </span>
                </div> --}}
                <div class="loadingCus loadingCenter m-0 p-0 h-100 align-items-center flex-column" x-show="loading">
                    <div class="loaderSpinnerVer1"></div>
                    <div>Loading...</div>
                </div>
            </div>
        </div>
    </template>
</div>
@stop
@section('script')
<script>
    Alpine.data('xViewInfo', () => ({
        dialogOpen:false,
        structureProgram: false,
        studentAttendanceOpen: false,
        students: [],
        student: [],
        classes: [],
        attendences: [],
        amount: null,
        loading:false,
        lesson_id: null,
        log_date: null,
        selectAll : false, 
        selectStudents: [],
        createStudyNote: false,
        // create study note
        student_id: null,
        description: null,
        noted_date: null,
        // study note of each student
        student_notes: [],
        openStructureProgram(){
            this.structureProgram = !this.structureProgram;
        },
        async dialogCreateStudyNote(student_id, class_id) {
            if(this.createStudyNote == false){
                this.loading = true;
                this.student_id = student_id;
                await this.fetchStudentNote(class_id, student_id, (res) => {
                    this.student_notes = res;
                });
                this.createStudyNote = true;
                this.loading = false;
            }else{
                this.createStudyNote = false;
            }
        },
        toggleAllCheckboxes() {
            this.selectAll = !this.selectAll
            this.selectStudents = [];

            checkboxes = document.querySelectorAll('.item-select-input');
            [...checkboxes].map((el) => {
                el.checked = this.selectAll;
                (this.selectAll) ? this.selectStudents.push(el.value) : this.selectStudents = [];
            })
        },
        init(){
        },
        dialogClassLog(){
            if(this.dialogOpen == false){
                this.dialogOpen = true;
            }else{
                this.dialogOpen = false;
            }
        },
        async fetchStudentNote(class_id, student_id, callback) {
            await Axios({
                url: `{{route('admin-study-note-student')}}`,
                method: 'GET',
                params: {
                    'student_id': student_id,
                    'class_id': class_id,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async dialogStudentAttendance(student_id, class_id){
            if(this.studentAttendanceOpen == false){
                this.loading = true;
                await this.fetchStudent(student_id, (res)=>{
                this.student = res;
                });

                await this.fetchClass(class_id, (res)=>{
                    this.class = res;
                });

                await this.fetchAttendance(class_id, (res)=>{
                    this.attendances = res;
                });

                await this.fetchStudentAttendanceAmount(class_id, student_id, (res)=>{
                    this.amount = res;
                });

                this.studentAttendanceOpen = true;
                this.loading = false;
            }else{
                this.studentAttendanceOpen = false;
            }
        },
        async fetchStudent(id, callback) {
            await Axios({
                url: `{{route('admin-listing-student')}}`,
                method: 'GET',
                params: {'id': id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async fetchClass(id, callback) {
            await Axios({
                url: `{{route('admin-listing-class')}}`,
                method: 'GET',
                params: {'id': id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async fetchAttendance(class_id, callback) {
            await Axios({
                url: `{{route('admin-listing-attendances')}}`,
                method: 'GET',
                params: {'class_id': class_id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async fetchStudentAttendanceAmount(class_id, student_id, callback) {
            await Axios({
                url: `{{route('admin-listing-student-attendance-amount')}}`,
                method: 'GET',
                params: {'class_id': class_id, 'student_id': student_id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async onUpdateStudentAttendance(class_id, student_id) {
            await Axios({
                url: `{{route('admin-attendance-update-student-attendance')}}`,
                method: 'POST',
                params: {
                    'class_id': class_id,
                    'lesson_id': this.lesson_id,
                    'student_id': student_id,
                    'log_date': this.log_date, 
                },
            }).then((response)=>{
                if (response.data.code == 20000) {
                    this.studentAttendanceOpen = false;
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
        },
        async onCreateStudyNote(class_id, student_id) {
            this.loading = true;
            await Axios({
                url: `{{route('admin-study-note-save')}}`,
                method: 'POST',
                params: {
                    'class_id': class_id,
                    'student_id': student_id,
                    'description': this.description,
                    'noted_date': this.noted_date,
                },
            }).then((response)=>{
                if (response.data.code == 20000) {
                    this.createStudyNote = false;
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'warning',
                    duration: 5000,
                });
            });
            this.loading = false;
        },
        async onDeleteStudentAttendance(id, student_id) {
            await Axios({
                url: `{{route('admin-attendance-delete-student-attendance')}}`,
                method: 'POST',
                params: {
                    'student_id': student_id,
                    'id': id, 
                },
            }).then((response)=>{
                if (response.data.code == 20000) {
                    this.studentAttendanceOpen = false;
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
        }
    }));
</script>
<script lang="ts">
    $(document).ready(function() {
        $validator("#form-create-study-note", {
            noted_date: {
                required: true,
            },
            description: {
                required: true,
            },
        });
    });
</script>
@stop