<div id="attendance" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('Attendance list') !!}
    </h2>
    <div class="row">
        <div class="form-row flex-row m-0 align-items-center">
            @can('attendance-print')
            <form class="d-flex align-items-center border-1-gray p-4 mr-2"
                action="{{route('admin-printing-attendance-date', request('id'))}}" method="GET">
                <label for="date">Select Date</label>
                <input type="date" name="date" id="date" class="mr-2 border-1-gray p-2 text-gray-400">
                <button class="btn-create bg-primary mr-2" s-click-link="">
                    <i data-feather="printer"></i>
                    <span>{!! strtoupper('Print attendane student') !!}</span>
                </button>
            </form>
            <button class="btn-create bg-primary mr-2"
                s-click-link="{{route('admin-printing-attendance', ['id' => $data->id, 'about'=> false])}}">
                <i data-feather="printer"></i>
                <span>{!! strtoupper('print current attendace record') !!}</span>
            </button>
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('student ID') !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm">{!! strtoupper('Student name') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('today attend: [').$today.']' !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm">{!! strtoupper('attend amount') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('attend sum') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('attend. %') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('att. status') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('action') !!}</span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    @php
                    $count = 0;
                    @endphp
                    @foreach($data->students->sortBy('id') as $student)
                    <div class="column">
                        <div class="row table-row-10">
                            <span>{!! $student->id ? $student->id : '--' !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{!! $student->name_khmer ? $student->name_khmer : '--' !!}</span>
                        </div>
                        <div class="row table-row-20">
                            <span class="font-sm {!! isset($today_attend->student_id) ? in_array($student->id,
                                $today_attend->student_id) ? 
                                'text-success' : 
                                'text-danger' : 
                                'text-danger'
                                !!}">
                                {!! isset($today_attend->student_id) ? in_array($student->id,
                                $today_attend->student_id) ? 'YES' : 'NO' : 'NO'
                                !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                @foreach($attendances as $attendance)
                                @if(in_array($student->id, $attendance->student_id))
                                @php
                                $count += 1
                                @endphp
                                @endif
                                @endforeach
                                {{$count}}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! $count.'/'.count($attendances)!!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! $count != 0 ? round(($count/count($attendances)*100)) : '0'
                                !!}.00
                                %</span>
                        </div>
                        <div class="row table-row-10">
                            @if( $count != 0 && round(($count/count($attendances)*100)) >=50)
                            <span class="text-success">
                                PASSED
                            </span>
                            @else
                            <span class="text-danger">
                                FAILED
                            </span>
                            @endif
                        </div>
                        <div class="row table-row-10 h-100 d-flex justify-content-center align-items-center">
                            @can('attendance-view-info')
                            <span class="font-sm h-50">
                                <button class="btn-create bg-primary h-100"
                                    @click="dialogStudentAttendance({{$student->id}}, {{request('id')}})">
                                    <span>{!! strtoupper('Detail') !!}</span>
                                </button>
                            </span>
                            @endcan
                        </div>
                    </div>
                    @php
                    $count = 0;
                    @endphp
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.class.view-info.modal.student-attendance')
</div>