<template x-if="dialogOpen">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3">
            <div class="d-flex flex-row-reverse justify-content-between">
                <span @click="dialogOpen=false" class="cursor-pointer btn-close">
                </span>
                <h2>
                    {!! strtoupper('Class log information') !!}
                </h2>
            </div>
            <div class="row">
                <div class="form-row flex-row border-1 align-items-center p-2">
                    @can('attendance-create')
                    <a href="{!! route('admin-attendance-create', $data->id) !!}">
                        <button class="btn-create bg-primary mr-2">
                            <span>Insert Program Att</span>
                        </button>
                    </a>
                    @endcan
                    <form class="filter mr-2" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row">
                            <select>
                                <option>SELECT LESSON...</option>
                                @foreach($attendances as $attendance)
                                <option name="lesson_id"
                                    value="{!! isset($attendance->lesson_id) && $attendance->lesson_id ? $attendance->lesson_id : '--' !!}">
                                    {!! isset($attendance->lesson_id) && $attendance->lesson_id ?
                                    $attendance->lessons->short_name.'-'.$attendance->lessons->name : '--' !!}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </form>
                    <form class="filter mr-2" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="Attendance filter search"
                                value="{!! request('keyword') !!}" />
                        </div>
                    </form>
                </div>
            </div>
            <div class="row" style="height: 85%">
                <span class="font-weight-bold text-black">{!! strtoupper('class log table') !!}</span>
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-5">
                                <span class="font-sm">{!! strtoupper('N°') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Log date') !!}</span>
                            </div>
                            <div class="row table-row-65">
                                <span class="font-sm">{!! strtoupper('Lesson Name') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Action') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @foreach($attendances as $index => $attendance)
                            <div class="column">
                                <div class="row table-row-5">
                                    <span>
                                        {!! $index+1 !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! isset($attendance->log_date) && $attendance->log_date ?
                                        $attendance->log_date : '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-65">
                                    <span class="font-sm">
                                        {!! isset($attendance->lesson_id) && $attendance->lesson_id ?
                                        $attendance->lessons->short_name.'-'.$attendance->lessons->name : '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15 h-100 d-flex justify-content-center align-items-center">
                                    @can('attendance-destroy')
                                    <span class="font-sm h-50">
                                        <button class="btn-create bg-danger h-100" s-click-link="">
                                            <span>{!! strtoupper('Delete') !!}</span>
                                        </button>
                                    </span>
                                    @endcan
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>