<div class="table">
    @if ($data->count() > 0)
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-5">
                    <span>Nº</span>
                </div>
                <div class="row table-row-20">
                    <span>Name</span>
                </div>
                <div class="row table-row-20">
                    <span>Phone</span>
                </div>
                <div class="row table-row-50">
                    <span>Location</span>
                </div>
                <div class="row table-row-5">
                    <span></span>
                </div>
            </div>
            <div class="table-body">
                @foreach ($data as $index => $item)
                    <div class="column">
                        <div class="row table-row-5">
                            <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                        </div>
                        <div class="row table-row-20">
                            <span>{!! $item->place_name ? $item->place_name : '--' !!}</span>
                        </div>
                        <div class="row table-row-20">
                            <span>{!! $item->contact_number ? $item->contact_number : '--' !!}</span>
                        </div>
                        <div class="row table-row-50">
                            <span>{!! $item->location ? $item->location : '--' !!}</span>
                        </div>
                        <div class="row table-row-5">
                            @canany(['internship-place-update', 'internship-place-delete'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @if ($item->status != 'trash')
                                            @can('internship-place-update')
                                                <li>
                                                    <a class="dropdown-item" s-click-link="{!! route('admin-internship-place-create', $item->id) !!}">
                                                        <i data-feather="edit"></i>
                                                        <span>Edit</span>
                                                    </a>
                                                </li>
                                            @endcan
                                        @endif
                                    </ul>
                                </div>
                            @endcan
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="table-footer">
                @include('admin::components.pagination', ['paginate' => $data])
            </div>
        </div>
    @else
        @component('admin::components.empty',
            [
                'name' => 'Internship place is empty',
                'msg' => 'You can create a new internship place by clicking the button below.',
                'permission' => 'internship-place-create',
                'url' => route('admin-internship-place-create'),
                'button' => 'Create Internship Place',
            ])
        @endcomponent
    @endif
</div>
