@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-lesson-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-lesson-list', 1) !!}"></i>
                    {!! request('id') ? "Update" : "Create" !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Lesson occupation <span>*</span></label>
                        <select name="lesson_occupation_id">
                            <option value="">Please select lesson occupation</option>
                            @foreach($occupation as $value)
                                <option value="{!!$value->id!!}" {!! (request('id') && $data->lesson_occupation_id == $value->id) || old('status') == 1 ? 'selected' : '' !!}>{!!$value->name!!}</option>
                            @endforeach
                        </select>
                        @error('lesson_occupation_id')
                        <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Competency type<span>*</span> </label>
                        <select name="competency_type">
                            <option value="">Please select competency type of lesson</option>
                            <option value="Generic Competency" {!! (request('id') && $data->competency_type == "Generic Competency") ? 'selected' : '' !!}> Generic Competency</option>
                            <option value="Functional Competency" {!! (request('id') && $data->competency_type == "Functional Competency") ? 'selected' : '' !!}> Functional Competency</option>
                        </select>
                        @error('competency_type')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Name<span>*</span> </label>
                        <input type="text" name="name" value="{!! request('id') ? $data->name : old('name') !!}" placeholder="Name">
                            @error('name')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Short name<span>*</span></label>
                        <input type="text" name="short_name" value="{!! request('id') ? $data->short_name : old('short_name') !!}" placeholder="Short name" autocomplete="off">
                        @error('short_name')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Practice hour<span>*</span></label>
                        <input type="number" name="practice_hour" value="{!! request('id') ? $data->practice_hour : old('practice_hour') !!}" placeholder="Practice hour" autocomplete="off">
                        @error('practice_hour')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Theory hour<span>*</span></label>
                        <input type="number" name="theory_hour" value="{!! request('id') ? $data->theory_hour : old('theory_hour') !!}" placeholder="Theory hour" autocomplete="off">
                        @error('theory_hour')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Status<span>*</span></label>
                        <select name="status">
                            <option value="1" {!! (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' : '' !!}>@lang('user.form.status.active')</option>
                            <option value="2" {!! (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' : '' !!}>@lang('user.form.status.disable')</option>
                        </select>
                    </div>
                    <div class="form-row">
                        <label class="form-label">Document</label>
                        <div class="">
                            <div class="image-view {!! request('id') && isset($data) && $data->document != null ? 'active' : '' !!}" >
                                <span>{!! request('id') && isset($data) && $data->document != null ? $data->document : "Click Upload File"!!}</span>
                            </div>
                            <input class="form-control form-control-lg" type="file" accept="Application/pdf,.docx,.doc" name="document"  autocomplete="off"
                                   role="presentation">
                            <input type="hidden" name="pdf_file" value="{!! request('id') && isset($data) && $data->document != null ? $data->document : '' !!}">
                        </div>
                        @error('document')
                        <span class="error">{{$message}}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Video </label>
                        <textarea name="video" placeholder="Please input or paste the video link">{!! request('id') ? $data->video : old('video') !!}</textarea>
                        @error('video')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-lesson-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script lang="ts">
        $(document).ready(function() {
            $validator("#form", {
                lesson_occupation_id: {
                    required: true,
                },
                competency_type: {
                    required: true,
                },
                name: {
                    required: true,
                },
                short_name: {
                    required: true,
                },
                practice_hour: {
                    required: true,
                },
                theory_hour: {
                    required: true,
                },
                status: {
                    required:true
                }
            });
        });
    </script>
       <script>
        const header = {
            headers: {
                "Content-Type": "application/x-www-form-urlencoded;charset=utf-8",
                Accept: "application/json",
            },
            responseType: "json",
        };
        document.addEventListener('alpine:init', () => {
            Alpine.data("xService", () => ({}));
        });
    </script>
@stop
