<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>No</span>
            </div>
            <div class="row table-row-10">
                <span>Profile</span>
            </div>
            <div class="row table-row-20 text-left">
                <span>Name</span>
            </div>
            <div class="row table-row-15">
                <span>Email</span>
            </div>
            <div class="row table-row-15">
                <span>Phone</span>
            </div>
            <div class="row table-row-10">
                <span>Staff Type</span>
            </div>
            <div class="row table-row-10">
                <span>Staff Position</span>
            </div>
            <div class="row table-row-10">
                <span>CV</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-10">
                    <div class="thumbnail" data-fancybox data-src="{{ asset('file_manager' . $item->profile)  }}">
                        <img src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                    </div>
                </div>
                <div class="row table-row-20 text left bold">
                    <span>{!! $item->full_name ? $item->full_name : '--' !!}</span>
                </div>
                <div class="row table-row-15 text">
                    <span>{!! $item->email ? $item->email : '--' !!}</span>
                </div>
                <div class="row table-row-15 text">
                    <span>{!! $item->phone ? $item->phone : '--' !!}</span>
                </div>
                <div class="row table-row-10">
                    <span>
                        {{$item->staff_type->name ?? '--'}}
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>
                        {{$item->staff_position->name ?? '--'}}
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>{!!$item->cv!!}</span>
                </div>
                <div class="row table-row-5">
                    @canany(['staff-update', 'staff-delete'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('staff-update')
                            <li>
                                <a class="dropdown-item" s-click-link="{!! route('admin-staff-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>@lang('table.option.edit')</span>
                                </a>
                            </li>
                            @if ($item->status == 2)
                            <li>
                                <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                                                '{!! route('admin-staff-status', ['id' => $item->id, 'status' => 1]) !!}',
                                                                '@lang('dialog.msg.enable', ['name' => $item->name])',
                                                                {
                                                                    confirm: '@lang('dialog.button.enable')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                },
                                                            );">
                                    <i data-feather="rotate-ccw"></i>
                                    <span>@lang('table.option.enable')</span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                                '{!! route('admin-staff-status', ['id' => $item->id, 'status' => 2]) !!}',
                                                                '@lang('dialog.msg.disable', ['name' => $item->name])',
                                                                {
                                                                    confirm: '@lang('dialog.button.disable')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                }
                                                            );">
                                    <i data-feather="x-circle"></i>
                                    <span>@lang('table.option.disable')</span>
                                </a>
                            </li>
                            @endif
                            @endcan
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach

        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty', [
    'name' => 'Staff is empty',
    'msg' => 'You can create a new staff by clicking the button below.',
    'permission' => 'staff-create',
    'url' => route('admin-staff-create'),
    'button' => 'Create Staff',
    ])
    @endcomponent
    @endif
</div>