@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-structure-program-save-assign-class', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-structure-program-list', 1) !!}"></i>
                    Assign Structured Program to class
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label for="classes">Please assign this structured program with id of {!! $data->id !!} to<span>*</span></label>
                        <select id="classes" name="class_id">
                            <option value="">Please select class to assign</option>
                            @foreach($classes as $class)
                                @if(!$class->class_structure_program)
                                    <option value="{!! $class->id !!}">
                                        [Class ID: {!! $class->id !!}]
                                        [{!! $class->shift->name !!}]
                                        [{!! $class->class_status->name !!}]
                                        [{!! $class->class_level->name !!}]
                                        [{!! $class->class_type->name !!}]
                                        [{!! $class->generation !!}]
                                        [{!! $class->group !!}]
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-structure-program-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script>
        $(document).ready(function() {
            $("#date").datepicker({
                changeYear: true,
                dateFormat: "yy-mm-dd",
            });
        });
    </script>
@stop
