@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="p-3">
    <div class="w-100 mb-4">
        <div>
            <span>សូមបញ្ចូលលេខកូដថ្នាក់</span>
        </div>
        <form class="mt-3 w-100" action="{{ url()->current() }}" method="get">
            <div class="w-100">
                <input type="number" min="0" name="keyword" id="" class="w-100 p-2 bg-warning" placeholder="Search"
                    style="height: 30px; border:none;border-radius: 4px;color: #4f4f4f;">
            </div>
            <button class="mt-2 w-100 bg-primary text-align-center" style="height: 30px">
                <span class="w-100 text-light">ស្វែងរកថ្នាក់</span>
            </button>
        </form>
        <form class="mt-3 w-100" action="{{ url()->current()}}" method="get">
            <div class="w-100">
                <input type="text" name="first20" value="true" id="" class="w-100 p-2 bg-warning" placeholder="Search"
                    style="height: 30px; border:none;border-radius: 4px;color: #4f4f4f; display:none;">
            </div>
            <button class="mt-2 w-100 bg-danger text-align-center" style="height: 30px; border-radius: 4px;">
                <span class="w-100 text-light">បង្ហាញថ្នាក់ទាំង ២០ មុន</span>
            </button>
        </form>
    </div>
    <div>
        <div>
            <span>
                ចុចលេខកូដខាងក្រោមដើម្បីទៅកាន់ថ្នាក់ឲ្យបានលឿន
            </span>
        </div>
        <div class="d-flex flex-wrap mt-3 mb-3">
            @foreach($data_id as $value)
            <span class=" d-flex justify-content-center align-items-center"
                style="border-radius: 4px; border: 1px solid #4f4f4f; height:40px; width: 40px; margin-right: 10px; margin-bottom: 10px;">
                <a href="#{{$value->class_id}}">{{$value->class_id}}</a>
            </span>
            @endforeach
        </div>
        <div>
            <span>
                Result count: <span>{{count($data)}}</span>
            </span>
        </div>
        @foreach($data as $item)
        <div id="{{$item->class_id}}" class="mb-3" style="border: 1px solid #4f4f4f; border-radius: 4px;">
            <div class="d-flex justify-content-center align-items-center p-1" style="background: #4f4f4f">
                <span class="text-light">
                    លេខកូដថ្នាក់៖ <span>{{$item->classes->id ?? '--'}}</span>
                </span>
            </div>
            <div class="w-100" style="line-height: 1.75">
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            ចំនួនសិស្ស
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{count($item->classes->students) ?? 0}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            វេនសិក្សា
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->classes->shift->name ?? '--'}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            មុខរបរចម្បងនៃថ្នាក់
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->structure_program->class_occupation->name ?? '--'}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            កម្រិតថ្នាក់
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->classes->class_level->name ?? '--'}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            ជំនាន់ទី
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->classes->generation ?? '--'}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            កាលបរិច្ឆេទចាប់ផ្តើម
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->classes->start_date ?? '--'}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            គ្រូបង្រៀន
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->classes->staff->full_name ?? '--'}}
                        </span>
                    </div>
                </div>
                <div class="d-flex w-100" style="border-bottom: 1px solid #4f4f4f;">
                    <div class="w-50" style="border-right: 1px solid #4f4f4f;padding-left:10px;">
                        <span>
                            ស្ថានភាពថ្នាក់
                        </span>
                    </div>
                    <div class="w-50" style="padding-left: 10px;">
                        <span>
                            {{$item->classes->class_status->name ?? '--'}}
                        </span>
                    </div>
                </div>
            </div>
            <div class="w-100 mt-3">
                <div class="d-flex justify-content-center align-items-center">
                    <span>
                        សូមជ្រើសរើសសកម្មភាពខាងក្រោម
                    </span>
                </div>
                <div class="w-100">
                    <div class="w-100 d-flex justify-content-between">
                        <div s-click-link="{!! route('admin-teacher-portal-create', $item->classes->id) !!}"
                            class="cursor-pointer m-3 mb-0 d-flex justify-content-center align-items-center bg-danger"
                            style="border-radius: 4px;width: 30%; height: 30px;">
                            <span class="text-light">ដាក់វត្តមានសិស្ស</span>
                        </div>
                        <div s-click-link="{{ route('admin-teacher-portal-attend', $item->classes->id) }}"
                            class="cursor-pointer m-3 mb-0 d-flex justify-content-center align-items-center bg-success"
                            style="border-radius: 4px;width: 65%; height: 30px;">
                            <span class="text-light">សិស្សដែលមានវត្តមានថ្ងៃនេះ</span>
                        </div>
                    </div>
                    <div class="w-100 d-flex justify-content-between">
                        <div s-click-link="{{route('admin-teacher-portal-student', $item->classes->id)}}"
                            class="cursor-pointer m-3 mb-0 d-flex justify-content-center align-items-center bg-primary"
                            style="border-radius: 4px;width: 30%; height: 30px;">
                            <span class="text-light">បញ្ជីឈ្មោះសិស្ស</span>
                        </div>
                        <div s-click-link="{{route('admin-teacher-portal-class-attendance', $item->classes->id)}}"
                            class="cursor-pointer m-3 mb-0 d-flex justify-content-center align-items-center bg-primary"
                            style="border-radius: 4px;width: 65%; height: 30px;">
                            <span class="text-light">តារាងតាមដានថ្នាក់</span>
                        </div>
                    </div>
                    <div class="w-100 d-flex justify-content-between">
                        <div s-click-link="{{route('admin-teacher-portal-group', $item->classes->id)}}"
                            class="cursor-pointer m-3 mb-0 d-flex justify-content-center align-items-center bg-primary"
                            style="border-radius: 4px;width: 30%; height: 30px;">
                            <span class="text-light">បញ្ជីក្រុមសិស្ស</span>
                        </div>
                        <div s-click-link="{{route('admin-teacher-portal-additional-info', $item->classes->id)}}"
                            class="cursor-pointer m-3 mb-0 d-flex justify-content-center align-items-center bg-primary"
                            style="border-radius: 4px;width: 65%; height: 30px;">
                            <span class="text-light">ព័​ត៍​មាន​បន្ថែម</span>
                        </div>
                    </div>
                    <div s-click-link="{{route('admin-teacher-portal-exam', $item->classes->id)}}"
                        class=" cursor-pointer m-3 bg-primary d-flex justify-content-center align-items-center"
                        style="border-radius: 4px; height: 30px;">
                        <span class="text-light">គ្រប់គ្រងពិន្ទុសិស្ស</span>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
@stop